/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects.geomancy;

import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderProjectile;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityPillar;
import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.collect.Iterables;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class EntityBoulderSculptor
extends EntityBoulderProjectile {
    private static final float MAX_DIST_HORIZONTAL = 4.0f;
    private static final float MAX_DIST_VERTICAL = 2.4f;
    private static final int MAX_TRIES = 10;
    private EntityBoulderSculptor nextBoulder;
    private EntitySculptor sculptor;
    private EntityPillar pillar;
    protected boolean isMainPath = false;
    protected boolean descending = false;
    protected boolean replacementBoulder = false;
    private boolean spawnedNextBoulders = false;
    private int timeUntilActivation = -1;
    private float orbitSpeed = 0.0f;

    public EntityBoulderSculptor(EntityType<? extends EntityBoulderSculptor> type, Level world) {
        super((EntityType<? extends EntityBoulderProjectile>)type, world);
    }

    public EntityBoulderSculptor(EntityType<? extends EntityBoulderSculptor> type, Level world, LivingEntity caster, BlockState blockState, BlockPos pos, EntityGeomancyBase.GeomancyTier tier) {
        super((EntityType<? extends EntityBoulderProjectile>)type, world, caster, blockState, pos, tier);
    }

    public EntityBoulderSculptor(EntityType<? extends EntityBoulderSculptor> type, EntityBoulderSculptor other) {
        super((EntityType<? extends EntityBoulderProjectile>)type, other.m_9236_(), other.getCaster(), other.storedBlock, other.m_20183_(), other.getTier());
    }

    public void descend() {
        this.descending = true;
        if (this.sculptor != null) {
            this.sculptor.boulders.remove(this);
        }
    }

    @Override
    public boolean doRemoveTimer() {
        return false;
    }

    public void delayActivation(int delay) {
        this.timeUntilActivation = delay;
    }

    @Override
    protected boolean shouldExtendBoundsDown() {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if ((this.sculptor == null || this.pillar == null || (double)this.sculptor.m_21223_() <= 0.0) && this.getCaster() instanceof EntitySculptor) {
            this.sculptor = (EntitySculptor)this.getCaster();
            if (!this.m_9236_().m_5776_()) {
                this.sculptor.boulders.add(this);
            }
            this.pillar = this.sculptor.getPillar();
            if (!this.sculptor.isFighting() && !this.sculptor.isTesting()) {
                this.explode();
            }
        }
        if (!this.isTravelling() && this.sculptor != null && this.sculptor.m_5448_() != null) {
            if ((double)this.orbitSpeed < 0.02) {
                this.orbitSpeed = (float)((double)this.orbitSpeed + 0.001);
            }
            Vec3 between = this.m_20182_().m_82546_(this.sculptor.m_20182_());
            between = between.m_82524_(this.orbitSpeed);
            this.m_146884_(between.m_82549_(this.sculptor.m_20182_()));
        } else if (this.orbitSpeed > 0.0f) {
            this.orbitSpeed = (float)((double)this.orbitSpeed - 0.001);
        }
        if (!this.m_9236_().m_5776_() && this.f_19797_ > 2 && (this.sculptor == null || this.sculptor.m_213877_() || this.pillar == null || this.pillar.m_213877_() || this.pillar.isFalling() && !this.descending)) {
            this.explode();
            return;
        }
        if (!this.replacementBoulder && this.f_19797_ >= 2 && !this.spawnedNextBoulders) {
            this.nextBoulders();
        }
        if (!this.replacementBoulder && this.pillar != null && !this.m_9236_().m_5776_()) {
            if (this.pillar.m_20186_() + (double)this.pillar.getHeight() >= this.m_20186_() && !this.isActive()) {
                this.activate();
            } else if (!this.pillar.isRising() && !this.isActive() && this.m_20186_() - this.pillar.m_20186_() < (double)this.pillar.f_19797_) {
                this.activate();
            }
        }
        if (this.descending) {
            this.m_6478_(MoverType.SELF, new Vec3(0.0, -0.25, 0.0));
            if (Iterables.size((Iterable)this.m_9236_().m_186434_((Entity)this, this.m_20191_().m_82400_(0.1))) > 0) {
                this.m_146870_();
                return;
            }
        }
        if (!this.m_9236_().m_5776_() && this.replacementBoulder) {
            if (this.timeUntilActivation > 0) {
                --this.timeUntilActivation;
            } else if (this.timeUntilActivation == 0) {
                this.activate();
            }
        }
    }

    public void nextBoulders() {
        if (this.getCaster() == null || this.sculptor == null || this.pillar == null) {
            return;
        }
        this.spawnedNextBoulders = true;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.isMainPath && (double)this.f_19796_.m_188501_() < MathUtils.fit(this.sculptor.numLivePaths, 3.0, 7.0, 0.0, 0.45)) {
            --this.sculptor.numLivePaths;
            return;
        }
        int numNextBoulders = 1;
        if ((double)this.f_19796_.m_188501_() < MathUtils.fit(this.sculptor.numLivePaths, 1.0, 5.0, 0.15, 0.0)) {
            numNextBoulders = 2;
        }
        for (int i = 0; i < numNextBoulders; ++i) {
            boolean success = this.nextSingleBoulder();
            if (!success || i <= 0) continue;
            ++this.sculptor.numLivePaths;
        }
    }

    @Override
    protected boolean startActive() {
        return false;
    }

    public EntityBoulderSculptor getNextBoulderInstance() {
        int whichTierIndex = (int)(Math.pow(this.f_19796_.m_188501_(), 2.0) * (double)(EntityGeomancyBase.GeomancyTier.values().length - 2) + 1.0);
        if ((double)this.getHeightFrac() > 0.85 && whichTierIndex == 3) {
            whichTierIndex = 1;
        }
        EntityGeomancyBase.GeomancyTier nextTier = EntityGeomancyBase.GeomancyTier.values()[whichTierIndex];
        if ((double)this.getHeightFrac() > 0.45 && (double)this.f_19796_.m_188501_() < 0.15) {
            return new EntityBoulderSculptorCrumbling((EntityType<? extends EntityBoulderSculptorCrumbling>)((EntityType)EntityHandler.BOULDER_SCULPTOR_CRUMBLING.get()), this.m_9236_(), this.getCaster(), this.m_20183_(), nextTier, this.f_19796_.m_188503_(2));
        }
        return new EntityBoulderSculptor((EntityType<? extends EntityBoulderSculptor>)((EntityType)EntityHandler.BOULDER_SCULPTOR.get()), this.m_9236_(), this.getCaster(), Blocks.f_50069_.m_49966_(), this.m_20183_(), nextTier);
    }

    public boolean nextSingleBoulder() {
        EntityBoulderSculptor nextBoulder = this.getNextBoulderInstance();
        for (int j = 0; j < 10; ++j) {
            Vec3 randomPos;
            if (this.getHeightFrac() < 1.0f) {
                randomPos = this.chooseRandomLocation(nextBoulder);
            } else if (this.m_20182_().m_82542_(1.0, 0.0, 1.0).m_82554_(this.sculptor.m_20182_().m_82542_(1.0, 0.0, 1.0)) > 4.0) {
                randomPos = this.chooseTowardsSculptorLocation(nextBoulder);
            } else {
                return false;
            }
            nextBoulder.m_146884_(randomPos);
            if (!this.m_9236_().m_6443_(EntityBoulderSculptor.class, nextBoulder.m_20191_(), b -> b != this).isEmpty() || Iterables.size((Iterable)this.m_9236_().m_186434_((Entity)nextBoulder, nextBoulder.m_20191_())) != 0 || this.pillar.m_20191_().m_165893_(this.pillar.m_20186_() + (double)EntitySculptor.TEST_HEIGHT).m_82381_(nextBoulder.m_20191_())) continue;
            AABB toCheck = nextBoulder.m_20191_().m_82377_(4.0, (double)2.7f, 4.0).m_82386_(0.0, (double)-2.7f, 0.0);
            List platforms = this.m_9236_().m_45976_(EntityBoulderSculptor.class, toCheck);
            boolean obstructsPath = false;
            for (EntityBoulderSculptor platform : platforms) {
                if (platform == nextBoulder || nextBoulder.checkJumpPath(platform)) continue;
                obstructsPath = true;
                break;
            }
            if (obstructsPath) continue;
            this.m_9236_().m_7967_((Entity)nextBoulder);
            if (this.isMainPath && this.nextBoulder == null) {
                this.nextBoulder = nextBoulder;
                this.nextBoulder.setMainPath();
            }
            return true;
        }
        if (this.isMainPath) {
            this.spawnedNextBoulders = false;
        }
        return false;
    }

    protected Vec3 chooseRandomLocation(EntityBoulderSculptor nextBoulder) {
        EntityDimensions thisDims = (EntityDimensions)SIZE_MAP.get((Object)this.getTier());
        EntityDimensions nextDims = (EntityDimensions)SIZE_MAP.get((Object)nextBoulder.getTier());
        Vec3 startLocation = this.m_20182_();
        Vec2 fromPillarPos = new Vec2((float)(this.getCaster().m_20185_() - startLocation.f_82479_), (float)(this.getCaster().m_20189_() - startLocation.f_82481_));
        float horizontalOffset = Mth.m_216267_((RandomSource)this.f_19796_, (float)1.0f, (float)4.0f) + thisDims.f_20377_ / 2.0f + nextDims.f_20377_ / 2.0f;
        float verticalOffset = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)2.4f) - (nextDims.f_20378_ - thisDims.f_20378_);
        float baseAngle = (float)(-Math.toDegrees(Math.atan2(fromPillarPos.f_82471_, fromPillarPos.f_82470_)));
        float minRandomAngle = (float)(Math.min(Math.pow(3.0, -fromPillarPos.m_165907_() + 3.0f), 1.0) * 90.0);
        double radius = EntitySculptor.testRadiusAtHeight(startLocation.f_82480_ + (double)verticalOffset + (double)nextDims.f_20378_ - this.pillar.m_20186_());
        float maxRandomAngle = 180.0f - (float)(Math.min(Math.pow(3.0, (double)fromPillarPos.m_165907_() - radius), 1.0) * 90.0);
        float randomAngle = Mth.m_216267_((RandomSource)this.f_19796_, (float)minRandomAngle, (float)maxRandomAngle);
        if (this.f_19796_.m_188499_()) {
            randomAngle *= -1.0f;
        }
        randomAngle = (float)((double)randomAngle * (1.0 - Math.pow(this.getHeightFrac(), 5.0) * 0.75));
        Vec3 offset = new Vec3((double)horizontalOffset, (double)verticalOffset, 0.0);
        float finalAngle = (float)Math.toRadians(Mth.m_14177_((float)(baseAngle + randomAngle)));
        Vec3 nextLocation = startLocation.m_82549_(offset = offset.m_82524_(finalAngle));
        if (nextLocation.m_7098_() + (double)nextDims.f_20378_ > this.pillar.m_20186_() + (double)EntitySculptor.TEST_HEIGHT) {
            nextLocation = new Vec3(nextLocation.m_7096_(), this.pillar.m_20186_() + (double)EntitySculptor.TEST_HEIGHT - (double)nextDims.f_20378_, nextLocation.m_7094_());
        }
        return nextLocation;
    }

    protected Vec3 chooseTowardsSculptorLocation(EntityBoulderSculptor nextBoulder) {
        EntityDimensions thisDims = (EntityDimensions)SIZE_MAP.get((Object)this.getTier());
        EntityDimensions nextDims = (EntityDimensions)SIZE_MAP.get((Object)nextBoulder.getTier());
        Vec3 startLocation = this.m_20182_();
        Vec2 fromPillarPos = new Vec2((float)(this.getCaster().m_20185_() - startLocation.f_82479_), (float)(this.getCaster().m_20189_() - startLocation.f_82481_));
        float horizontalOffset = Mth.m_216267_((RandomSource)this.f_19796_, (float)1.0f, (float)4.0f) + thisDims.f_20377_ / 2.0f + nextDims.f_20377_ / 2.0f;
        float baseAngle = (float)(-Math.toDegrees(Math.atan2(fromPillarPos.f_82471_, fromPillarPos.f_82470_)));
        Vec3 offset = new Vec3((double)horizontalOffset, 0.0, 0.0);
        float finalAngle = (float)Math.toRadians(Mth.m_14177_((float)baseAngle));
        offset = offset.m_82524_(finalAngle);
        return startLocation.m_82549_(offset);
    }

    public EntityBoulderSculptor getNextBoulder() {
        return this.nextBoulder;
    }

    public boolean checkJumpPath(EntityBoulderSculptor platform) {
        EntityBoulderSculptor next = platform.getNextBoulder();
        if (next == null) {
            return true;
        }
        EntityDimensions platDims = (EntityDimensions)SIZE_MAP.get((Object)platform.getTier());
        EntityDimensions nextDims = (EntityDimensions)SIZE_MAP.get((Object)next.getTier());
        Vec3 toNext = next.m_20182_().m_82546_(platform.m_20182_());
        Vec3 startPos = platform.m_20182_().m_82520_(0.0, (double)platDims.f_20378_, 0.0).m_82549_(toNext.m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)(platDims.f_20377_ / 2.0f)));
        Vec3 endPos = next.m_20182_().m_82520_(0.0, (double)nextDims.f_20378_, 0.0).m_82549_(toNext.m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)(-nextDims.f_20377_ / 2.0f)));
        double gravity = -((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22082_();
        double jumpVelY = 1.0;
        double heightDiff = endPos.m_7098_() - startPos.m_7098_();
        double totalTime = (-jumpVelY - Math.sqrt(jumpVelY * jumpVelY - 4.0 * gravity * -heightDiff)) / (2.0 * gravity);
        double jumpVelX = (endPos.m_7096_() - startPos.m_7096_()) / totalTime;
        double jumpVelZ = (endPos.m_7094_() - startPos.m_7094_()) / totalTime;
        Vec3 jumpVel = new Vec3(jumpVelX, jumpVelY, jumpVelZ);
        AABB thisBounds = ((EntityDimensions)SIZE_MAP.get((Object)this.getTier())).m_20393_(this.m_20182_());
        int substeps = 5;
        for (int i = 0; i < substeps; ++i) {
            double time = totalTime / (double)substeps * (double)i;
            Vec3 jumpPosition = new Vec3(0.0, gravity * time * time, 0.0).m_82549_(jumpVel.m_82490_(time)).m_82549_(startPos);
            AABB playerBounds = EntityType.f_20532_.m_20680_().m_20393_(jumpPosition).m_82363_(0.0, 0.5, 0.0);
            if (!thisBounds.m_82381_(playerBounds)) continue;
            return false;
        }
        return true;
    }

    public void setMainPath() {
        this.isMainPath = true;
    }

    public float getHeightFrac() {
        EntitySculptor sculptor;
        EntityPillar.EntityPillarSculptor pillar;
        if (this.getCaster() instanceof EntitySculptor && (pillar = (sculptor = (EntitySculptor)this.getCaster()).getPillar()) != null) {
            return (float)(this.m_20182_().m_7098_() + (double)this.m_20206_() - pillar.m_20186_()) / (float)EntitySculptor.TEST_HEIGHT;
        }
        return -1.0f;
    }

    @Override
    public void m_142687_(Entity.RemovalReason p_146834_) {
        super.m_142687_(p_146834_);
        if (this.sculptor != null) {
            this.sculptor.boulders.remove(this);
        }
    }

    @Override
    protected float fallingBlockCountMultiplier() {
        return 0.2f;
    }

    @Override
    protected float getShootRingParticleScale() {
        return super.getShootRingParticleScale() * 4.0f;
    }

    @Override
    public void shoot(Vec3 shootDirection) {
        super.shoot(shootDirection);
        EntityBoulderSculptor boulderSculptor = new EntityBoulderSculptor((EntityType<? extends EntityBoulderSculptor>)((EntityType)EntityHandler.BOULDER_SCULPTOR.get()), this);
        boulderSculptor.m_146884_(this.m_20182_());
        boulderSculptor.replacementBoulder = true;
        boulderSculptor.delayActivation(40);
        this.m_9236_().m_7967_((Entity)boulderSculptor);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("SpawnedNext", this.spawnedNextBoulders);
        compound.m_128379_("Descending", this.descending);
        compound.m_128379_("MainPath", this.isMainPath);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.spawnedNextBoulders = compound.m_128471_("SpawnedNext");
        this.descending = compound.m_128471_("Descending");
        this.isMainPath = compound.m_128471_("MainPath");
    }

    public static class EntityBoulderSculptorCrumbling
    extends EntityBoulderSculptor {
        public static final int CRUMBLE_DURATION = 35;
        private int crumbleTick = 35;
        private int consecutiveCrumblers;
        private static final EntityDataAccessor<Boolean> CRUMBLING = SynchedEntityData.m_135353_(EntityBoulderSculptorCrumbling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

        public EntityBoulderSculptorCrumbling(EntityType<? extends EntityBoulderSculptor> type, Level world) {
            super(type, world);
        }

        public EntityBoulderSculptorCrumbling(EntityType<? extends EntityBoulderSculptorCrumbling> type, Level world, LivingEntity caster, BlockPos pos, EntityGeomancyBase.GeomancyTier tier, int consecutiveCrumblers) {
            super((EntityType<? extends EntityBoulderSculptor>)type, world, caster, Blocks.f_50493_.m_49966_(), pos, tier);
            this.consecutiveCrumblers = consecutiveCrumblers;
        }

        public EntityBoulderSculptorCrumbling(EntityType<? extends EntityBoulderSculptorCrumbling> type, EntityBoulderSculptorCrumbling other) {
            super((EntityType<? extends EntityBoulderSculptor>)type, other.m_9236_(), other.getCaster(), other.storedBlock, other.m_20183_(), other.getTier());
        }

        @Override
        public EntityBoulderSculptor getNextBoulderInstance() {
            int whichTierIndex = (int)(Math.pow(this.f_19796_.m_188501_(), 2.0) * (double)(EntityGeomancyBase.GeomancyTier.values().length - 2) + 1.0);
            if ((double)this.getHeightFrac() > 0.85 && whichTierIndex == 3) {
                whichTierIndex = 1;
            }
            EntityGeomancyBase.GeomancyTier nextTier = EntityGeomancyBase.GeomancyTier.values()[whichTierIndex];
            if (this.consecutiveCrumblers > 0) {
                return new EntityBoulderSculptorCrumbling((EntityType<? extends EntityBoulderSculptorCrumbling>)((EntityType)EntityHandler.BOULDER_SCULPTOR_CRUMBLING.get()), this.m_9236_(), this.getCaster(), this.m_20183_(), nextTier, this.consecutiveCrumblers - 1);
            }
            return new EntityBoulderSculptor((EntityType<? extends EntityBoulderSculptor>)((EntityType)EntityHandler.BOULDER_SCULPTOR.get()), this.m_9236_(), this.getCaster(), Blocks.f_50069_.m_49966_(), this.m_20183_(), nextTier);
        }

        @Override
        protected void m_8097_() {
            super.m_8097_();
            this.m_20088_().m_135372_(CRUMBLING, (Object)false);
        }

        @Override
        public void m_8119_() {
            super.m_8119_();
            if (!this.m_9236_().m_5776_() && !this.isCrumbling()) {
                List onTopOfEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82310_(0.0, (double)(this.m_20206_() - 1.0f), 0.0).m_82383_(new Vec3(0.0, (double)this.m_20206_() - 0.5, 0.0)).m_82377_(-0.1, 0.5, -0.1));
                for (Entity entity : onTopOfEntities) {
                    if (entity == null || !entity.m_6087_() || entity instanceof EntityBoulderProjectile || !(entity.m_20186_() >= this.m_20186_() + 0.2) || !entity.m_20096_()) continue;
                    this.setCrumbling(true);
                    this.m_5496_((SoundEvent)MMSounds.ENTITY_SCULPTOR_PLATFORM_CRUMBLE.get(), 1.0f, 1.0f);
                }
            }
            if (this.descending) {
                this.setCrumbling(false);
            }
            if (this.isCrumbling() && !this.descending) {
                --this.crumbleTick;
                if (this.crumbleTick == 0) {
                    this.crumble();
                }
            }
        }

        private void crumble() {
            this.explode();
            if (!this.m_9236_().m_5776_()) {
                EntityBoulderSculptorCrumbling boulderSculptor = new EntityBoulderSculptorCrumbling((EntityType<? extends EntityBoulderSculptorCrumbling>)((EntityType)EntityHandler.BOULDER_SCULPTOR_CRUMBLING.get()), this);
                boulderSculptor.m_146884_(this.m_20182_());
                boulderSculptor.replacementBoulder = true;
                boulderSculptor.delayActivation(40);
                this.m_9236_().m_7967_((Entity)boulderSculptor);
            }
        }

        public void setCrumbling(boolean crumbling) {
            this.m_20088_().m_135381_(CRUMBLING, (Object)crumbling);
        }

        public boolean isCrumbling() {
            return (Boolean)this.m_20088_().m_135370_(CRUMBLING);
        }

        public int getCrumbleTick() {
            return this.crumbleTick;
        }

        @Override
        public void m_7380_(CompoundTag compound) {
            super.m_7380_(compound);
            compound.m_128405_("ConsecutiveCrumblers", this.consecutiveCrumblers);
        }

        @Override
        public void m_7378_(CompoundTag compound) {
            super.m_7378_(compound);
            this.consecutiveCrumblers = compound.m_128451_("ConsecutiveCrumblers");
        }
    }
}

